//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define DEF_INTERACTIVE "Interactive"
//+----------------+
#define def_Fibonacci_Element_Default   6
//+------------------------------------------------------------------+
void OnStart(void)
{
    Print("Result to ",
#ifdef DEF_INTERACTIVE
        DEF_INTERACTIVE, " : "
#else
        "Recursive : "
#endif
    , Fibonacci());
}
//+------------------------------------------------------------------+
uint Fibonacci(uint arg = def_Fibonacci_Element_Default)
{
#ifdef DEF_INTERACTIVE

    uint v, i, c;

    for (c = 0, i = 0, v = 1; c < arg; i += v, c += 2)
        v += i;

    return (c == arg ? i : v);

#else    

    if (arg <= 1)
        return arg;

    return Fibonacci(arg - 1) +  Fibonacci(arg - 2);

#endif
}
//+------------------------------------------------------------------+